﻿using System;
using System.IO;

namespace NewOfficeInterop
{
    class Program
    {
        // Listing 1-4. Współpraca z Microsoft Office w C# 4.0
        static void Main(string[] args)
        {
            // Niewielka zmiana w porównaniu z kodem przykładu zamieszczonym
            // w książce, która ma związek z tym, że niektóre wersje 
            // pakietu Office będą domyślnie przeszukiwać bibliotek 
            // w katalogu c:\Windows\System32.
            string path = Path.Combine(
                Directory.GetCurrentDirectory(),
                @"WordFile.docx");

            var wordApp = new Microsoft.Office.Interop.Word.Application();
            Microsoft.Office.Interop.Word._Document doc =
                wordApp.Documents.Open(path, ReadOnly: true);
            dynamic docProperties = doc.BuiltInDocumentProperties;
            string authorName = docProperties["Author"].Value;
            doc.Close(SaveChanges: false);
            Console.WriteLine(authorName);
        }
    }
}
